using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI;
using CONTROLS = gov.va.med.vbecs.GUI.controls;
using System.Text.RegularExpressions;
using System.Text;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// RowVersionChangedEventHandler Delegate
	/// </summary>
	public delegate void RowVersionChangedEventHandler(object sender, EventArgs e, byte[] rowVersion);

	/// <summary>
	/// Summary description for DataGridDAT.
	/// </summary>
	public class DataGridDat : System.Windows.Forms.Panel
	{
		private Hashtable resultLookup;
		private System.Windows.Forms.DataGridTableStyle _dgPSAHGTableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgPSAHG;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.ComponentModel.IContainer components;
		private DataTable _dtDAT;
		private BOL.Division _division;
		private string _validEntries;
		private System.Windows.Forms.GroupBox grpDATPS;
		private System.Windows.Forms.TextBox txtPSLotNumber;
		private System.Windows.Forms.TextBox txtPSManufacturer;
		private System.Windows.Forms.Label lblPSLotNumber;
		private System.Windows.Forms.TextBox txtPSExpires;
		private System.Windows.Forms.Label lblPSExpires;
		private System.Windows.Forms.Label lblPSManufacturer;
		private controls.ComboBoxLookup cmbBox;
		private controls.ComboBoxLookup cmbBoxComment;
		private DataTable _dtReagents;
		private BOL.OrderedTest _orderedTest;
		private string _testingTech;
		private DateTime _testDate;
		private char _testStatusCode;
		private System.Guid _parentFormGuid = System.Guid.Empty;
		private DataTable _dtRemovedLotNumbers;
		private bool _keyPressEventHandled;

		/// <summary>
		/// enableInvalidation
		/// </summary>
		public bool enableInvalidation;

		/// <summary>
		/// CellChanged Event
		/// </summary>
		public event CellChangedEventHandler CellChanged;

		/// <summary>
		/// RowVersionChanged Event
		/// </summary>
		public event RowVersionChangedEventHandler RowVersionChanged;

		/// <summary>
		/// The constructor of the control
		/// </summary>
		public DataGridDat()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			//I put this try/catch just to make this control appear on the UC_56 main windows in the design view
			try
			{
				this._division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			}
			catch{}

			InitializeGrid();
			_dtRemovedLotNumbers = new DataTable();
			_dtRemovedLotNumbers.Columns.Add(ARTIFICIAL.Lot_Number);
			_dtRemovedLotNumbers.Columns.Add(ARTIFICIAL.Manufacturer);
			_dtRemovedLotNumbers.CaseSensitive = true;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DataGridDat));
			this.dgPSAHG = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.btnClear = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.cmbBox = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cmbBoxComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.grpDATPS = new System.Windows.Forms.GroupBox();
			this.txtPSLotNumber = new System.Windows.Forms.TextBox();
			this.txtPSManufacturer = new System.Windows.Forms.TextBox();
			this.lblPSLotNumber = new System.Windows.Forms.Label();
			this.txtPSExpires = new System.Windows.Forms.TextBox();
			this.lblPSExpires = new System.Windows.Forms.Label();
			this.lblPSManufacturer = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.dgPSAHG)).BeginInit();
			this.grpDATPS.SuspendLayout();
			this.SuspendLayout();
			// 
			// dgPSAHG
			// 
			this.dgPSAHG.AllowSorting = false;
			this.dgPSAHG.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgPSAHG.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgPSAHG.CaptionText = "Direct Antiglobulin Test (DAT PS)";
			this.dgPSAHG.CaptionVisible = false;
			this.dgPSAHG.DataMember = string.Empty;
//			this.dgPSAHG.Direction = gov.va.med.vbecs.GUI.controls.GridDirection.Up;
			this.dgPSAHG.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgPSAHG.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgPSAHG.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgPSAHG.Location = new System.Drawing.Point(0, 0);
			this.dgPSAHG.Name = "dgPSAHG";
			this.dgPSAHG.RowHeadersVisible = false;
			this.dgPSAHG.Size = new System.Drawing.Size(454, 92);
			this.dgPSAHG.TabIndex = 59;
			this.dgPSAHG.ToolTipColumn = -1;
			this.dgPSAHG.CurrentCellChanged += new System.EventHandler(this.dgPSAHG_CurrentCellChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Image = ((System.Drawing.Image)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new System.Drawing.Point(432, 0);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new System.Drawing.Size(20, 20);
			this.btnClear.TabIndex = 60;
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// cmbBox
			// 
			this.cmbBox.Interval = 500;
			this.cmbBox.Location = new System.Drawing.Point(0, 0);
			this.cmbBox.MaxLength = 15;
			this.cmbBox.Name = "cmbBox";
			this.cmbBox.Size = new System.Drawing.Size(98, 21);
			this.cmbBox.TabIndex = 0;
			this.cmbBox.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBox_Validating);
			this.cmbBox.SelectedIndexChanged += new System.EventHandler(this.cmbBox_SelectedIndexChanged);
			// 
			// cmbBoxComment
			// 
			this.cmbBoxComment.Interval = 500;
			this.cmbBoxComment.Location = new System.Drawing.Point(0, 0);
			this.cmbBoxComment.MaxLength = 255;
			this.cmbBoxComment.Name = "cmbBoxComment";
			this.cmbBoxComment.Size = new System.Drawing.Size(113, 21);
			this.cmbBoxComment.TabIndex = 0;
			this.cmbBoxComment.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBoxComment_Validating);
			// 
			// grpDATPS
			// 
			this.grpDATPS.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpDATPS.Controls.Add(this.txtPSLotNumber);
			this.grpDATPS.Controls.Add(this.txtPSManufacturer);
			this.grpDATPS.Controls.Add(this.lblPSLotNumber);
			this.grpDATPS.Controls.Add(this.txtPSExpires);
			this.grpDATPS.Controls.Add(this.lblPSExpires);
			this.grpDATPS.Controls.Add(this.lblPSManufacturer);
			this.grpDATPS.Location = new System.Drawing.Point(456, 0);
			this.grpDATPS.Name = "grpDATPS";
			this.grpDATPS.Size = new System.Drawing.Size(276, 92);
			this.grpDATPS.TabIndex = 90;
			this.grpDATPS.TabStop = false;
			// 
			// txtPSLotNumber
			// 
			this.txtPSLotNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPSLotNumber.Location = new System.Drawing.Point(92, 16);
			this.txtPSLotNumber.Name = "txtPSLotNumber";
			this.txtPSLotNumber.ReadOnly = true;
			this.txtPSLotNumber.Size = new System.Drawing.Size(176, 20);
			this.txtPSLotNumber.TabIndex = 86;
			this.txtPSLotNumber.TabStop = false;
			this.txtPSLotNumber.Text = string.Empty;
			// 
			// txtPSManufacturer
			// 
			this.txtPSManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPSManufacturer.Location = new System.Drawing.Point(92, 40);
			this.txtPSManufacturer.Name = "txtPSManufacturer";
			this.txtPSManufacturer.ReadOnly = true;
			this.txtPSManufacturer.Size = new System.Drawing.Size(176, 20);
			this.txtPSManufacturer.TabIndex = 3;
			this.txtPSManufacturer.TabStop = false;
			this.txtPSManufacturer.Text = string.Empty;
			// 
			// lblPSLotNumber
			// 
			this.lblPSLotNumber.Location = new System.Drawing.Point(4, 16);
			this.lblPSLotNumber.Name = "lblPSLotNumber";
			this.lblPSLotNumber.Size = new System.Drawing.Size(72, 20);
			this.lblPSLotNumber.TabIndex = 79;
			this.lblPSLotNumber.Text = "Lot Number";
			this.lblPSLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPSExpires
			// 
			this.txtPSExpires.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPSExpires.Location = new System.Drawing.Point(92, 64);
			this.txtPSExpires.Name = "txtPSExpires";
			this.txtPSExpires.ReadOnly = true;
			this.txtPSExpires.Size = new System.Drawing.Size(176, 20);
			this.txtPSExpires.TabIndex = 4;
			this.txtPSExpires.TabStop = false;
			this.txtPSExpires.Text = string.Empty;
			// 
			// lblPSExpires
			// 
			this.lblPSExpires.Location = new System.Drawing.Point(4, 64);
			this.lblPSExpires.Name = "lblPSExpires";
			this.lblPSExpires.Size = new System.Drawing.Size(80, 20);
			this.lblPSExpires.TabIndex = 85;
			this.lblPSExpires.Text = "Expires";
			this.lblPSExpires.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPSManufacturer
			// 
			this.lblPSManufacturer.Location = new System.Drawing.Point(4, 40);
			this.lblPSManufacturer.Name = "lblPSManufacturer";
			this.lblPSManufacturer.Size = new System.Drawing.Size(84, 20);
			this.lblPSManufacturer.TabIndex = 83;
			this.lblPSManufacturer.Text = ARTIFICIAL.Manufacturer;
			this.lblPSManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DataGridDat
			// 
			this.Controls.Add(this.grpDATPS);
			this.Controls.Add(this.btnClear);
			this.Controls.Add(this.dgPSAHG);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "DataGridDat";
			this.Size = new System.Drawing.Size(732, 92);
			((System.ComponentModel.ISupportInitialize)(this.dgPSAHG)).EndInit();
			this.grpDATPS.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Locking

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			if (this.UserActivity != null)
				this.UserActivity(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// Guid of the control's container - needed for locking
		/// </summary>
		public System.Guid ParentFormGuid
		{
			get
			{
				if (this._parentFormGuid == System.Guid.Empty)
				{
					throw new BOL.BusinessObjectException("Locking Requirement missing -- ParentFormGuid not set.");
				}
				return(this._parentFormGuid);
			}
			set
			{
				this._parentFormGuid = value;
			}
		}

		#endregion

		/// <summary>
		/// Set or get the division code
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._division.DivisionCode;
			}
			set
			{
				if (value != null)
				{
					this._division = new BOL.Division(value);
				}
			}
		}

		/// <summary>
		/// Get the valid entries description for grid cell
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		/// <summary>
		/// Set the OrderedTest object associated with this test
		/// </summary>
		public BOL.OrderedTest OrderedTest
		{
			set
			{
				this._orderedTest = value;
			}
			get
			{
				return this._orderedTest;
			}
		}

		/// <summary>
		/// Get or set the testing tech
		/// </summary>
		public string TestingTech
		{
			get
			{
				return this._testingTech;
			}
			set
			{
				this._testingTech = value;
			}
		}

		/// <summary>
		/// Get or set the testing date
		/// </summary>
		public DateTime TestDate
		{
			get
			{
				return this._testDate;
			}
			set
			{
				this._testDate = value;
			}
		}

		/// <summary>
		/// Get the name of the qc rack
		/// </summary>
		public string RackName
		{
			get
			{
				if (this._dtDAT.Rows[0].IsNull(TABLE.Rack.RackGuid) == false)
				{
					BOL.Rack rack = new BOL.Rack((Guid)this._dtDAT.Rows[0][TABLE.Rack.RackGuid]);
					return rack.RackName;
				}
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Update row version when the part of the order (TAS or ABS) has been invalidated
		/// </summary>
		public byte[] RowVersionOrderedTest
		{
			set
			{
				this._dtDAT.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = value;
				this.OrderedTest.RowVersion = value;
				if (this.IsGridPartiallyCompleted() == false)
				{
					foreach(DataRow dr in this._dtDAT.Rows)
					{
						dr[ARTIFICIAL.AHGGuid] = DBNull.Value;
						dr[ARTIFICIAL.CCGuid] = DBNull.Value;
						dr[ARTIFICIAL.AHGInterpGuid] = DBNull.Value;
						dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
						dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
						dr[ARTIFICIAL.AHGInterpRowVersion] = DBNull.Value;
					}
				}
			}
		}

		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnCellChanged(EventArgs e)
		{
			if (CellChanged != null)
				CellChanged(this.dgPSAHG, e);

			this.OnUserActivity();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Initialize the datagrid and set the DataTableStyle
		/// </summary>
		private void InitializeGrid()
		{
			this.dgPSAHG.CaptionVisible = true;
			this.dgPSAHG.Enter += new System.EventHandler(dgPSAHG_Enter);
			this.dgPSAHG.Leave += new EventHandler(dgPSAHG_Leave);
			this.dgPSAHG.LostFocus +=new EventHandler(dgPSAHG_LostFocus);
			this.dgPSAHG.SizeChanged +=new EventHandler(dgPSAHG_SizeChanged);
			this.dgPSAHG.NextCell += new controls.NextCellEventHandler(SetNextCell);
//			this.dgPSAHG.Direction = GridDirection.Down;
			//
			InitializeLookup();
			//
			AddPSAHGCustomDataTableStyle();
			this._keyPressEventHandled = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the "Positive" and "Negative" values of each test result
			resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add(string.Empty, "X");
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");
		}

		/// <summary>
		/// Creates the DAT table that is used as a datasource for the datagrid. This method
		/// also creates one row in this table that allows user to enter test results.
		/// </summary>
		/// <returns></returns>
		public DataTable CreateDatTable(BOL.OrderedTest test, Guid rackGuid)
		{
			bool datResultsExist = false;
			this._orderedTest = test;
			DataTable dt = new System.Data.DataTable("DAT");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add(ARTIFICIAL.TestType, typeof(string));
			dt.Columns.Add(TABLE.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHGInterp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.AHGComment, typeof(string));
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLE.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.ReagentType.ReagentTypeId, typeof(int));
			dt.Columns.Add(ARTIFICIAL.Manufacturer, typeof(string));
			dt.Columns.Add(TABLE.ExceptionExpiredUnitReceived.ExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId);
			dt.Columns.Add(ARTIFICIAL.SystemAHGInterp, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.LotNumberSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGInterpSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGInterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGInterpRowVersion, typeof(byte[]));
			dt.Columns.Add(TABLE.OrderedTest.CprsOrderNumber);
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.ReagentExpiredException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.EmergencyIssueExceptions, typeof(ArrayList));
			dt.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dt.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage);

			DataRow dr = dt.NewRow();
			dr[TABLE.Patient.PatientGuid] = test.Patient.PatientGuid;
			dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = test.Specimen.SpecimenGuid;
			dr[TABLE.OrderedTest.OrderedTestGuid] = test.OrderedTestGuid;
			dr[ARTIFICIAL.OrderedTestRowVersion] = test.RowVersion;

			if (this._division.PatientTestingConfiguration == Common.PatientTestingConfiguration.AntibodyDAT &&
				test.OrderableTestId == (int)Common.OrderableTest.ABS)
			{
				dr[TABLE.OrderableTest.OrderableTestId] = (int)Common.OrderableTest.DAT;
			}
			else
			{
				dr[TABLE.OrderableTest.OrderableTestId] = test.OrderableTestId;
			}

			dr[ARTIFICIAL.Indicator] = string.Empty;

			//veryfing if there are any DAT results in the database
			//if not than treat this test as not started (for TAS and ABS+DAT only)
			DataTable dtSpecimenTests = BOL.OrderedTest.GetTestResultsForTask(test.OrderedTestGuid);
			if (dtSpecimenTests.Select(TABLE.BloodTestType.BloodTestName + " LIKE '*DAT*'").Length > 0)
				datResultsExist = true;
		
			if ((datResultsExist == true &&
				test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected)) ||
				test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				this._testStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted);
			}

			if (this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) &&
				datResultsExist == true)
			{
				dr[TABLE.Reagent.LotNumber] = string.Empty;
				dr[ARTIFICIAL.AHG] = DBNull.Value;
				dr[ARTIFICIAL.CC] = DBNull.Value;
				dr[ARTIFICIAL.LotNumberSave] = true;
				dr[ARTIFICIAL.AHGSave] = false;
				dr[ARTIFICIAL.CCSave] = false;
				dr[ARTIFICIAL.TestType] = "Patient";
			}
			else
			{
				if (this._division.ServiceTypeIndicator == true)
				{
					dr[TABLE.Reagent.LotNumber] = string.Empty;
					dr[ARTIFICIAL.AHG] = string.Empty;
					dr[ARTIFICIAL.CC] = string.Empty;
					dr[ARTIFICIAL.LotNumberSave] = true;
					dr[ARTIFICIAL.AHGSave] = true;
					dr[ARTIFICIAL.CCSave] = true;
					dr[ARTIFICIAL.TestType] = "Poly AHG";
				}
				else //Transfusion-Only
				{
					dr[TABLE.Reagent.LotNumber] = DBNull.Value;
					dr[ARTIFICIAL.AHG] = DBNull.Value;
					dr[ARTIFICIAL.CC] = DBNull.Value;
					dr[ARTIFICIAL.LotNumberSave] = false;
					dr[ARTIFICIAL.AHGSave] = false;
					dr[ARTIFICIAL.CCSave] = false;
					dr[ARTIFICIAL.TestType] = "Patient";
				}
			}

			dr[ARTIFICIAL.AHGInterp] = string.Empty;
			dr[ARTIFICIAL.AHGComment] = string.Empty;
			dr[ARTIFICIAL.AHGInterpSave] = true;
			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDAT;  //PS AHG
			dr[TABLE.OrderedTest.CprsOrderNumber] = test.CPRSOrderNumber;
			dr[ARTIFICIAL.IndicatorMessage] = string.Empty;

			if (rackGuid != Guid.Empty)
				dr[TABLE.Rack.RackGuid] = rackGuid;

			if (test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = true;
			else
				dr[TABLE.SpecimenTest.CorrectedResultIndicator] = false;

			dt.Rows.Add(dr);

			this.dgPSAHG.ToolTipColumn = dt.Columns.Count - 1;
			return dt;
		}
		
		/// <summary>
		/// Adds or removes two rows used to QC PS AHG reagent
		/// </summary>
		/// <param name="addRows"></param>
		private void AddRemoveQCRowsToDataGrid(bool addRows)
		{
			if (addRows == true)
			{
				DataRow drNeg = this._dtDAT.NewRow();
				drNeg[TABLE.Patient.PatientGuid] = this._dtDAT.Rows[0][TABLE.Patient.PatientGuid];
				drNeg[TABLE.PatientSpecimen.PatientSpecimenGuid] = this._dtDAT.Rows[0][TABLE.PatientSpecimen.PatientSpecimenGuid];
				drNeg[TABLE.OrderedTest.OrderedTestGuid] = this._dtDAT.Rows[0][TABLE.OrderedTest.OrderedTestGuid];
				drNeg[TABLE.OrderableTest.OrderableTestId] = this._dtDAT.Rows[0][TABLE.OrderableTest.OrderableTestId];
				drNeg[TABLE.OrderedTest.CprsOrderNumber] = this._dtDAT.Rows[0][TABLE.OrderedTest.CprsOrderNumber];
				drNeg[ARTIFICIAL.Indicator] = string.Empty;
				drNeg[ARTIFICIAL.TestType] = "NEG";
				drNeg[TABLE.Reagent.LotNumber] = string.Empty;
				drNeg[ARTIFICIAL.AHG] = string.Empty;
				drNeg[ARTIFICIAL.CC] = string.Empty;
				drNeg[ARTIFICIAL.AHGInterp] = string.Empty;
				drNeg[ARTIFICIAL.AHGComment] = string.Empty;
				drNeg[ARTIFICIAL.LotNumberSave] = true;
				drNeg[ARTIFICIAL.AHGSave] = true;
				drNeg[ARTIFICIAL.CCSave] = true;
				drNeg[ARTIFICIAL.AHGInterpSave] = true;
				drNeg[ARTIFICIAL.PartiallyCompleted] = false;
				drNeg[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDATNegControl;  //Screening Cell 1
				drNeg[ARTIFICIAL.OrderedTestRowVersion] = this._dtDAT.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
				drNeg[TABLE.Rack.RackGuid] = this._dtDAT.Rows[0][TABLE.Rack.RackGuid];
				drNeg[ARTIFICIAL.IndicatorMessage] = string.Empty;

				DataRow drPos = this._dtDAT.NewRow();
				drPos[TABLE.Patient.PatientGuid] = this._dtDAT.Rows[0][TABLE.Patient.PatientGuid];
				drPos[TABLE.PatientSpecimen.PatientSpecimenGuid] = this._dtDAT.Rows[0][TABLE.PatientSpecimen.PatientSpecimenGuid];
				drPos[TABLE.OrderedTest.OrderedTestGuid] = this._dtDAT.Rows[0][TABLE.OrderedTest.OrderedTestGuid];
				drPos[TABLE.OrderableTest.OrderableTestId] = this._dtDAT.Rows[0][TABLE.OrderableTest.OrderableTestId];
				drPos[TABLE.OrderedTest.CprsOrderNumber] = this._dtDAT.Rows[0][TABLE.OrderedTest.CprsOrderNumber];
				drPos[ARTIFICIAL.Indicator] = string.Empty;
				drPos[ARTIFICIAL.TestType] = "POS";
				drPos[TABLE.Reagent.LotNumber] = string.Empty;
				drPos[ARTIFICIAL.AHG] = string.Empty;
				drPos[ARTIFICIAL.CC] = string.Empty;
				drPos[ARTIFICIAL.AHGInterp] = string.Empty;
				drPos[ARTIFICIAL.AHGComment] = string.Empty;
				drPos[ARTIFICIAL.LotNumberSave] = true;
				drPos[ARTIFICIAL.AHGSave] = true;
				drPos[ARTIFICIAL.CCSave] = true;
				drPos[ARTIFICIAL.AHGInterpSave] = true;
				drPos[ARTIFICIAL.PartiallyCompleted] = false;
				drPos[TABLE.ReagentType.ReagentTypeId] = (int)Common.DATTestControls.PSDATPosControl;  //Check Cells
				drPos[ARTIFICIAL.OrderedTestRowVersion] = this._dtDAT.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
				drPos[TABLE.Rack.RackGuid] = this._dtDAT.Rows[0][TABLE.Rack.RackGuid];
				drPos[ARTIFICIAL.IndicatorMessage] = string.Empty;

				object[] objPatient = this._dtDAT.Rows[0].ItemArray;
				DataRow drPatient = this._dtDAT.NewRow();
				drPatient.ItemArray = objPatient;

				this._dtDAT.Rows.Add(drPos);
				this._dtDAT.Rows.Add(drNeg);
				this._dtDAT.Rows.Add(drPatient);
				this._dtDAT.Rows.RemoveAt(0);

				this.dgPSAHG.SetCurrentCell(0,0);
			}
			else
			{
				if (this._dtDAT.Rows.Count > 1)
				{
					this._dtDAT.Rows.RemoveAt(0);
					this._dtDAT.Rows.RemoveAt(0);

					this.dgPSAHG.SetCurrentCell(0,0);
				}
			}
		}

		/// <summary>
		/// Sets the data source for a grid. Transfers DataTable to a DataView and passes it as
		/// a source for a grid.
		/// </summary>
		/// <param name="dt"></param>
		public void SetDataSource(DataTable dt)
		{
			if (dt.Rows.Count == 0)
			{
				this.dgPSAHG.DataSource = dt.DefaultView;
				this.dgPSAHG.ColumnHeadersVisible = false;
				this.btnClear.Enabled = false;
				enableInvalidation = false;
			}
			else
			{
				this.btnClear.Enabled = true;
				enableInvalidation = false;
				this.dgPSAHG.ColumnHeadersVisible = true;
				this.dgPSAHG.DataSource = dt.DefaultView;
				((DataView)dgPSAHG.DataSource).AllowNew = false;
				((DataView)dgPSAHG.DataSource).AllowDelete = false;
				this.cmbBoxComment.SelectedIndex = -1;

				this._dtDAT = dt;
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}
			}
		}

		/// <summary>
		/// Enables or disables the grid
		/// </summary>
		/// <param name="status"></param>
		public void SetGridStatus(bool status)
		{
			this.dgPSAHG.Enabled = status;
		}

		/// <summary>
		/// Check if data on the grid is ready to be saved to the database
		/// </summary>
		/// <returns></returns>
		public bool IsReadyToSave()
		{
			DataTable dt = ((DataView)this.dgPSAHG.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					if (dt.Rows[i].IsNull(TABLE.Reagent.ReagentGuid) == true ||
						dt.Rows[i][ARTIFICIAL.Indicator].ToString() == "E")
						return false;
				}
			}
			else //Transfusion-Only
			{
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					if (dt.Rows[i][ARTIFICIAL.Indicator].ToString() == string.Empty)
						return false;
				}
			}

			return true;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddPSAHGCustomDataTableStyle()
		{
			_dgPSAHGTableStyle = new DataGridTableStyle();
			_dgPSAHGTableStyle.PreferredRowHeight = 22;
			dgPSAHG.TableStyles.Add(_dgPSAHGTableStyle);

			_dgPSAHGTableStyle.AllowSorting = false;
			_dgPSAHGTableStyle.DataGrid = this.dgPSAHG;

			_dgPSAHGTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgPSAHGTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgPSAHGTableStyle.MappingName = "DAT";
			_dgPSAHGTableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// PatientControl
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = string.Empty;
			_dcTextBox.MappingName = ARTIFICIAL.TestType;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 55;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// Lot Number
			// 
			if (this._division != null)
			{
				if (this._division.ServiceTypeIndicator == true)
				{
					_dcTextBox = new DataGridTextBoxColumn();
					_dcTextBox.HeaderText = "Lot Number";
					_dcTextBox.MappingName = TABLE.Reagent.LotNumber;
					_dcTextBox.Width = 100;
					_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
					_dcTextBox.TextBox.Controls.Add(cmbBox);
					cmbBox.BringToFront();
					cmbBox.LookupEnabled = false;
					cmbBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
				}
				else
				{
					_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
					_dcTextKeyTrapCol.HeaderText = "Lot Number";
					_dcTextKeyTrapCol.MappingName = TABLE.Reagent.LotNumber;
					_dcTextKeyTrapCol.Width = 100;
					_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
				}
			}

			// 
			// PSAHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "PS AHG";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.Width = 50;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 25;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// PSAHGInterp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHGInterp;
			_dcTextKeyTrapCol.Width = 80;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// PSAHGComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = ARTIFICIAL.Comment;
			_dcTextBox.MappingName = ARTIFICIAL.AHGComment;
			_dcTextBox.Width = 115;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextBox.TextBox.Controls.Add(cmbBoxComment);
			cmbBoxComment.BringToFront();
			cmbBoxComment.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// dcPatientGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientSpecimenGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.PatientSpecimen.PatientSpecimenGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedTestGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.OrderedTestGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Reagent.ReagentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentTypeID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ReagentType.ReagentTypeId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcManufacturer
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.Manufacturer;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcExpirationDate
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.ExceptionExpiredUnitReceived.ExpirationDate;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderableTestID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcSystemAHGInterp
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.SystemAHGInterp;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPartiallyCompleted
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcLotNumberSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.LotNumberSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGInterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGInterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCprsOrderNumber
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.CprsOrderNumber;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRowVersionOrderedTest
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedTestRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcReagentExpiredException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ReagentExpiredException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcEmergencyIssueExceptions
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.EmergencyIssueExceptions;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCorrectedResultIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.SpecimenTest.CorrectedResultIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgPSAHGTableStyle.GridColumnStyles.Add(_dcTextBox);
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// BR_2.28
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgPSAHG.CurrentCell.RowNumber;
				int column = this.dgPSAHG.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if (!char.IsLetterOrDigit(e.KeyChar))
				{
					if (column == 6 && e.KeyChar == System.Convert.ToChar(Keys.Enter))
					{
						SetNextCell();
					}

					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}

				if (column == 6)
					return;

				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression
				if (column == 5)  // interp
				{
					regPattern = @"(\A[PN]\z)";
				}
				else if (column == 3)			// AHG
				{
					regPattern = @"(\A[HWFM01234]\z)";
				}
				else if (column == 4)			// CC
				{
					regPattern = @"(\A[HWFM01234X]\z)";
				}

				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening
					this._keyPressEventHandled = true;
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					DataTable dt = ((DataView)this.dgPSAHG.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					SetNextCell();
					UpdateIndicator(row);
					this._keyPressEventHandled = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
			
				e.Handled = true;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void _dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			//if the grid just received focus do not continue executing this event
			if (this.dgPSAHG.GridEntered == true)
			{
				this.dgPSAHG.GridEntered = false;
				return;
			}

			if (this._keyPressEventHandled || this.dgPSAHG.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgPSAHG.CurrentCell.RowNumber;
				int column = this.dgPSAHG.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgPSAHG.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 5)  // interp
						{
							regPattern = @"(\A[PN]\z)";
						}
						else if (column == 3)			// AHG
						{
							regPattern = @"(\A[HWFM01234]\z)";
						}
						else if (column == 4)			// CC
						{
							regPattern = @"(\A[HWFM01234X]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							for (int i=0 ; i<this._dtDAT.Rows.Count ; i++)
							{
								UpdateIndicator(i);
							}
							this.dgPSAHG.Refresh();
							OnCellChanged(EventArgs.Empty);
							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
					//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";
						for (int i=0 ; i<this._dtDAT.Rows.Count ; i++)
						{
							UpdateIndicator(i);
						}
						this.dgPSAHG.Refresh();
						OnCellChanged(EventArgs.Empty);
						this._keyPressEventHandled = false;
					}
				}
			}
		}

		/// <summary>
		/// Controls the movement of the cursor on the datagrid.
		/// </summary>
		private void SetNextCell()
		{
			int row = this.dgPSAHG.CurrentCell.RowNumber;
			int col = this.dgPSAHG.CurrentCell.ColumnNumber;

			if (row == this._dtDAT.Rows.Count - 1)
			{
				if (col < 6 && col > 1)
				{
					this.dgPSAHG.SetCurrentCell(0, col+1);
				}
				else if (col == 6)
				{
					this.dgPSAHG.SetCurrentCell(0, 0);
				}
			}
			else
			{
				this.dgPSAHG.SetCurrentCell(row + 1, col);
			}
		}

		/// <summary>
		/// Updates the datagrid indicator to indicate the status of test results
		/// </summary>
		private void UpdateIndicator(int row)
		{
			//int row = this.dgPSAHG.CurrentCell.RowNumber;
			DataRow drUpdate = this._dtDAT.Rows[row];
			bool showOverrideMsgs = true;

			this.btnClear.Enabled = false;
			enableInvalidation = false;
			foreach(DataRow dr in this._dtDAT.Rows)
			{
				if (dr[ARTIFICIAL.AHGInterp].ToString().Trim() == string.Empty ||
					(bool)dr[ARTIFICIAL.AHGInterpSave] == true)
				{
					this.btnClear.Enabled = true;
					enableInvalidation = true;
				}
			}

			if (btnClear.Enabled == false)
				showOverrideMsgs = false;

			//if (this._division.ServiceTypeIndicator == true ||
			//(this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			//CRT - 101405 - The Partially Completed check will allow Transfusion-Only sites to enter here when returning from save
			if (this._division.ServiceTypeIndicator == true)
			{
				string AHGResult = resultLookup[drUpdate[ARTIFICIAL.AHG].ToString()].ToString();
				string CCResult = resultLookup[drUpdate[ARTIFICIAL.CC].ToString()].ToString();
				string Interp = drUpdate[ARTIFICIAL.AHGInterp].ToString();

				if (AHGResult == string.Empty || CCResult == string.Empty)
				{
					drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
				}
				else
				{
					if (Interp != string.Empty)
					{
						if (CCResult == "N" || drUpdate[ARTIFICIAL.CC].ToString().Trim() == string.Empty ||
							(AHGResult == "N" && drUpdate[ARTIFICIAL.CC].ToString().Trim() == "X"))
						{
							if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
							{
								drUpdate[ARTIFICIAL.Indicator] = "E";
								drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
							}
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
						}
						else
						{
							if (drUpdate[ARTIFICIAL.TestType].ToString() == "Patient")
							{
								if ((AHGResult == "P" && Interp == "P") ||
									(AHGResult == "N" && Interp == "N"))
								{
									drUpdate[ARTIFICIAL.Indicator] = "V";
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								}
								else
								{
									if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
									{
										drUpdate[ARTIFICIAL.Indicator] = "E";
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
									}
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								}
							}
							else if (drUpdate[ARTIFICIAL.TestType].ToString() == "POS")
							{
								if (AHGResult == "P" && Interp == "P")
								{
									drUpdate[ARTIFICIAL.Indicator] = "V";
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								}
								else
								{
									if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
									{
										drUpdate[ARTIFICIAL.Indicator] = "E";
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
									}
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								}
							}
							else if (drUpdate[ARTIFICIAL.TestType].ToString() == "NEG")
							{
								if (AHGResult == "N" && Interp == "N")
								{
									drUpdate[ARTIFICIAL.Indicator] = "V";
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								}
								else
								{
									if (drUpdate[ARTIFICIAL.Indicator].ToString() != "E")
									{
										drUpdate[ARTIFICIAL.Indicator] = "E";
										drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC054.InvalidEntry().ResString;
									}
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
								}
							}
						}
					}
					else
					{
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					}
				}
			}
			else //Transfusion-Only facility
			{
				if (drUpdate[ARTIFICIAL.AHGInterp].ToString().Trim() != string.Empty)
				{
					drUpdate[ARTIFICIAL.Indicator] = "V";
					drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
				}
				else
				{
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
					drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
				}
			}

			//BR_56.29
			if (drUpdate[ARTIFICIAL.TestType].ToString() == "Patient")
			{
				if (drUpdate[ARTIFICIAL.AHGInterp].ToString().Trim() == "P")
				{
					if (BOL.OrderedTest.GetEmergencyIssuedUnitsForOrderedTest(this._orderedTest.OrderedTestGuid).Rows.Count > 0)
					{
						if (this._dtDAT.Rows[0].IsNull(ARTIFICIAL.EmergencyIssueExceptions) &&
							showOverrideMsgs == true)
						{
							DataTable dtIssuedUnits = BOL.OrderedTest.GetEmergencyIssuedUnitsForOrderedTest(this._orderedTest.OrderedTestGuid);
							if (dtIssuedUnits.Rows.Count > 0)
							{
								DlgOverrideComment dlg = new DlgOverrideComment( "Positive DAT Result", Common.StrRes.SysErrMsg.UC056.EmergencyUnitsIssued().ResString, "PT" );

                                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                dlg.ShowDialogFromLockedParent(parentForm, false);
                                if (dlg.DialogResult == DialogResult.Cancel)
								{
									drUpdate[ARTIFICIAL.AHGInterp] = string.Empty;
									drUpdate[ARTIFICIAL.Indicator] = string.Empty;
									drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
									drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
									if (this._dtDAT.Rows.Count == 1)
										this.dgPSAHG.SetCurrentCell(0, 5);
									else
										this.dgPSAHG.SetCurrentCell(2, 5);
									return;
								}
								else
								{
									ArrayList emergencyIssueExceptions = new ArrayList();
									foreach(DataRow drIssuedUnit in dtIssuedUnits.Rows)
									{
										BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_ER_issued_testing_problem, dlg.Comment, Common.LogonUser.LogonUserName);
										exRep.GenerateExceptionEmergencyIssueUnitTest((Guid)drIssuedUnit[TABLE.OrderedUnit.BloodUnitGuid], (Guid)this._dtDAT.Rows[0][TABLE.Patient.PatientGuid], "DAT", "Pos", this.TestingTech);
										emergencyIssueExceptions.Add(exRep);
									}
									this._dtDAT.Rows[0][ARTIFICIAL.EmergencyIssueExceptions] = emergencyIssueExceptions;
								}
							}
						}
					}
				}
				else
				{
					this._dtDAT.Rows[0][ARTIFICIAL.EmergencyIssueExceptions] = DBNull.Value;
				}
			}
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// </summary>
		/// <param name="column"></param>
		public void SetValidEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 2)	//Lot Number
			{
				_validEntries = "Lot Number";
			}
			else if (column == 3)		// AHG
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, M = Microscopic";
			}
			else if (column == 4)		// CC
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, H = Hemolysis, W = Weak, F = Mixed Field, M = Microscopic, X = Not Tested";
			}
			else if (column == 5)  // IgG interp
			{
				_validEntries = "P = Positive, N = Negative";
			}
			else if (column == 6)		// IgG Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = "Read-Only";
			}
		}

		/// <summary>
		/// Clears the test results from the grid. Restores datagrid to the initial status.
		/// </summary>
		private void ClearTestResults(bool clearAll)
		{
			if (this._dtDAT.Rows.Count > 0)
			{
				if (this._division.ServiceTypeIndicator == true ||
					this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					foreach(DataRow drDAT in this._dtDAT.Rows)
					{
						if ((bool)drDAT[ARTIFICIAL.LotNumberSave] == true ||
							clearAll == true)
						{
							drDAT[TABLE.Reagent.LotNumber] = string.Empty;
							drDAT[TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = DBNull.Value;
							drDAT[ARTIFICIAL.Manufacturer] = string.Empty;
							drDAT[TABLE.Reagent.ReagentGuid] = DBNull.Value;
							if (clearAll == true)
								drDAT[ARTIFICIAL.LotNumberSave] = true;
							drDAT[ARTIFICIAL.TestType] = "Poly AHG";
						}

						if ((bool)drDAT[ARTIFICIAL.AHGSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.AHG] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.AHGSave] = true;
								drDAT[ARTIFICIAL.AHGGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
							}
						}

						if ((bool)drDAT[ARTIFICIAL.CCSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.CC] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.CCSave] = true;
								drDAT[ARTIFICIAL.CCGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.CCRowVersion] = DBNull.Value;
							}
						}

						if ((bool)drDAT[ARTIFICIAL.AHGInterpSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.AHGInterp] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.AHGInterpSave] = true;
								drDAT[ARTIFICIAL.AHGInterpGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.AHGInterpRowVersion] = DBNull.Value;
							}
						}
						drDAT[ARTIFICIAL.AHGComment] = string.Empty;
						drDAT[ARTIFICIAL.ReagentExpiredException] = DBNull.Value;
					}
				}
				else //Transfusion-Only
				{
					foreach(DataRow drDAT in this._dtDAT.Rows)
					{
						if ((bool)drDAT[ARTIFICIAL.AHGInterpSave] == true ||
							clearAll == true)
						{
							drDAT[ARTIFICIAL.AHGInterp] = string.Empty;
							if (clearAll == true)
							{
								drDAT[ARTIFICIAL.AHGInterpSave] = true;
								drDAT[ARTIFICIAL.AHGInterpGuid] = DBNull.Value;
								drDAT[ARTIFICIAL.AHGInterpRowVersion] = DBNull.Value;
							}
						}
						drDAT[ARTIFICIAL.AHGComment] = string.Empty;
					}
				}

				this.cmbBox.Text = string.Empty;
				this.cmbBoxComment.Text = string.Empty;

				for (int i=0; i<this._dtDAT.Rows.Count; i++)
				{
					UpdateIndicator(i);
				}
				this.dgPSAHG.SetCurrentCell(0, 1);
			}
		}

		/// <summary>
		/// Handles the CellChanged event for datagrid. Controls the movement of the cursor
		/// on the gird and updates the indicator flag after each cell is edited.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dgPSAHG_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				bool fullGrid = true;
				int col = this.dgPSAHG.CurrentCell.ColumnNumber;
				int row = this.dgPSAHG.CurrentCell.RowNumber;

				foreach (DataRow drDAT in this._dtDAT.Rows)
				{
					if ((bool)drDAT[ARTIFICIAL.LotNumberSave] == true ||
						(bool)drDAT[ARTIFICIAL.AHGSave] == true ||
						(bool)drDAT[ARTIFICIAL.CCSave] == true ||
						(bool)drDAT[ARTIFICIAL.AHGInterpSave] == true)
					{
						fullGrid = false;
					}
				}

				if (fullGrid == true)
				{
					this.dgPSAHG.Enabled = false;
					return;
				}

				if (this._division.ServiceTypeIndicator == true ||
					this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
				{
					if (this._dtDAT.Rows[row].IsNull(TABLE.Reagent.ReagentGuid) && col != 2)
					{
						this.dgPSAHG.SetCurrentCell(row, 2);
						return;
					}

					if (col == 0 || col == 1)
					{
						this.dgPSAHG.SetCurrentCell(row, 2);
						return;
					}

					switch(this.dgPSAHG.CurrentCell.ColumnNumber)
					{
						case 2:
							if ((bool)this._dtDAT.Rows[row][ARTIFICIAL.LotNumberSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 3:
							if ((bool)this._dtDAT.Rows[row][ARTIFICIAL.AHGSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 4:
							if ((bool)this._dtDAT.Rows[row][ARTIFICIAL.CCSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 5:
							if ((bool)this._dtDAT.Rows[row][ARTIFICIAL.AHGInterpSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
					}
				}
				else //Transfusion-Only
				{
					if (col < 5)
					{
						this.dgPSAHG.SetCurrentCell(row, 5);
					}
				}

				if (col > 6)
					this.dgPSAHG.SetCurrentCell(row, 6);
				else if (col == 2)
				{
					if (this._dtDAT.Rows[row][ARTIFICIAL.TestType].ToString() == "POS" ||
						this._dtDAT.Rows[row][ARTIFICIAL.TestType].ToString() == "NEG")
					{
						DataTable dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ReverseABO);
						this._dtReagents = dtTmpReagents.Copy();
						this._dtReagents.CaseSensitive = true;

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.A2Cell);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.ScreeningCells);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.CC);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}

						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.CellPanel);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}
				
						dtTmpReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)Common.ReagentType.OtherSet);
						foreach(DataRow dr in dtTmpReagents.Rows)
						{
							this._dtReagents.Rows.Add(dr.ItemArray);
						}
					}
					else
					{
						_dtReagents = BOL.Reagent.GetReagentsByType(this.DivisionCode, (int)this._dtDAT.Rows[row][TABLE.ReagentType.ReagentTypeId]);
						this._dtReagents.CaseSensitive = true;
					}
					DataView dv = new DataView(_dtReagents);
					dv.Sort = TABLE.Reagent.LotExpirationDate + " DESC";
					cmbBox.Items.Clear();
					foreach(DataRowView drReagent in dv)
					{
						if (this._dtRemovedLotNumbers.Select("Lot_Number = '" + drReagent.Row[TABLE.Reagent.LotNumber].ToString().Replace("'", "''") + "' AND Manufacturer = '" + drReagent.Row[TABLE.Reagent.ReagentManufacturerName].ToString().Replace("'", "''") + "'").Length == 0)
							cmbBox.Items.Add(drReagent.Row[TABLE.Reagent.LotNumber].ToString());
					}

					cmbBox.Text = this._dtDAT.Rows[row][TABLE.Reagent.LotNumber].ToString();

					cmbBox.Show();
					cmbBox.Focus();
				}
				else if (col == 6)
				{
					if ((bool)this._dtDAT.Rows[row][ARTIFICIAL.AHGInterpSave] == false ||
						this._dtDAT.Rows[row][ARTIFICIAL.AHGInterp].ToString() == string.Empty)
					{
						SetNextCell();
					}
					else
					{
						if (this.cmbBoxComment.Items.Count == 0)
						{
							DataTable dtCannedComments = BOL.CannedComment.GetCannedComments(this.DivisionCode, "PT");
							foreach (DataRow drComment in dtCannedComments.Rows)
							{
								this.cmbBoxComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
							}
							this.cmbBoxComment.LookupEnabled = false;
						}
						this.cmbBoxComment.Text = this._dtDAT.Rows[row][ARTIFICIAL.AHGComment].ToString();
						this.cmbBoxComment.Show();
						this.cmbBoxComment.Focus();
					}
				}

				if (this._dtDAT.Rows[row].IsNull(Common.VbecsTables.Reagent.ReagentGuid) == false)
				{
					DataRow drReagent = BOL.Reagent.GetReagent((Guid)this._dtDAT.Rows[row][Common.VbecsTables.Reagent.ReagentGuid]);
					this.txtPSLotNumber.Text = drReagent[TABLE.Reagent.LotNumber].ToString();
					this.txtPSExpires.Text = drReagent[TABLE.Reagent.LotExpirationDate].ToString();
					this.txtPSManufacturer.Text = drReagent[TABLE.Reagent.ReagentManufacturerName].ToString();
				}
				else
				{
					this.txtPSLotNumber.Text = string.Empty;
					this.txtPSExpires.Text = string.Empty;
					this.txtPSManufacturer.Text = string.Empty;
				}

				for (int i=0 ; i<this._dtDAT.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}

				SetValidEntries(this.dgPSAHG.CurrentCell.ColumnNumber);
				OnCellChanged(EventArgs.Empty);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Handles the KeyDown event for combobox.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_KeyDown(object sender, KeyEventArgs e)
		{
			try
			{
				if (e.KeyCode == Keys.Enter)
				{
					if(this.dgPSAHG.CurrentCell.RowNumber < ((DataTable)this.dgPSAHG.DataSource).Rows.Count - 1)
					{
						this.dgPSAHG.SetCurrentCell(this.dgPSAHG.CurrentCell.RowNumber + 1, this.dgPSAHG.CurrentCell.ColumnNumber);
						cmbBox.Show();
						cmbBox.Focus();
					}
					else
					{
						this.dgPSAHG.SetCurrentCell(0, this.dgPSAHG.CurrentCell.ColumnNumber+1);
						cmbBox.Hide();
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Handles the IndexChanged event for combobox. Finds the reagent based on the lot number
		/// chosen and populates grid with the appropriate data.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (cmbBox.SelectedIndex != -1)
				{
					int row = this.dgPSAHG.CurrentCell.RowNumber;
					int column = this.dgPSAHG.CurrentCell.ColumnNumber;

                    // CR2814: Add an escape character so queries with single quotes don't crash.
					DataRow drReagent = this._dtReagents.Select(TABLE.Reagent.LotNumber + "='" + cmbBox.SelectedItem.ToString().Replace("'", "''") + "'")[0];

					if (this._dtDAT.Rows[row][TABLE.Reagent.LotNumber].ToString().Trim() != drReagent[TABLE.Reagent.LotNumber].ToString().Trim())
					{
						if (this.CheckForExpiredAntisera(drReagent) == true &&
							this.CheckForSatisfactoryReagent(drReagent) == true)
						{
							this._dtDAT.Rows[row][TABLE.Reagent.LotNumber] = drReagent[TABLE.Reagent.LotNumber];
							this._dtDAT.Rows[row][TABLE.ExceptionExpiredUnitReceived.ExpirationDate] = drReagent[TABLE.Reagent.LotExpirationDate];
							this._dtDAT.Rows[row][ARTIFICIAL.Manufacturer] = drReagent[TABLE.Reagent.ReagentManufacturerName];
							this._dtDAT.Rows[row][TABLE.Reagent.ReagentGuid] = drReagent[TABLE.Reagent.ReagentGuid];

							if (this._dtDAT.Rows[row].IsNull(TABLE.Reagent.LotNumber) == false)
								this.txtPSLotNumber.Text = this._dtDAT.Rows[row][TABLE.Reagent.LotNumber].ToString();
							else
								this.txtPSLotNumber.Text = string.Empty;

							if (this._dtDAT.Rows[row].IsNull(TABLE.ExceptionExpiredUnitReceived.ExpirationDate) == false)
								this.txtPSExpires.Text = this._dtDAT.Rows[row][TABLE.ExceptionExpiredUnitReceived.ExpirationDate].ToString();
							else
								this.txtPSExpires.Text = string.Empty;

							if (this._dtDAT.Rows[row].IsNull(ARTIFICIAL.Manufacturer) == false)
								this.txtPSManufacturer.Text = this._dtDAT.Rows[row][ARTIFICIAL.Manufacturer].ToString();
							else
								this.txtPSManufacturer.Text = string.Empty;

							if (this._dtDAT.Rows[row][ARTIFICIAL.TestType].ToString() == "Poly AHG")
							{
								this._dtDAT.Rows[row][ARTIFICIAL.TestType] = "Patient";
							}

							if (this._dtDAT.Rows[row][ARTIFICIAL.TestType].ToString() == "Patient")
							{
								//unlike Anti-IgG and Anti-Comp PS AHG reagent is always part of daily qc
								//so checking whether daily qc has been completed is enough to determine if PS AHG has been QCd
								DataTable dtRacks = BOL.Rack.GetDailyQCRacks(this.TestDate);
								DataRow drRack = null;
								bool rackQCd = false;
								if (dtRacks.Select(Common.VbecsTables.Rack.RackName + " = '" + this.RackName + "'").Length > 0)
									drRack = dtRacks.Select(Common.VbecsTables.Rack.RackName + " = '" + this.RackName + "'")[0];

								if (drRack != null)
								{
									if( !drRack.IsNull( Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate ))
									{
										if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator] == false)
											rackQCd = true;
									}
								}

								//after checking if the rack was QCd I have to check if the selected LotNumber belongs to a rack
								if (rackQCd == true)
								{
									DataTable dt = BOL.Reagent.GetReagentFromRack((Guid)drRack[Common.VbecsTables.Rack.RackGuid],(int)Common.ReagentType.PSAHG, Common.LogonUser.LogonUserDivisionCode);
                                    // CR2814: Add an escape character toe single quotes for the query.
                                    if (dt.Select(Common.VbecsTables.Reagent.LotNumber + " = '" + this._dtDAT.Rows[row][TABLE.Reagent.LotNumber].ToString().Trim().Replace("'", "''") + "'").Length == 0)
										rackQCd = false;
								}

								if (rackQCd == false && this._dtDAT.Rows.Count == 1)
								{
									this.AddRemoveQCRowsToDataGrid(true);
								}
								else if (rackQCd == true && this._dtDAT.Rows.Count == 3)
								{
									this.AddRemoveQCRowsToDataGrid(false);
								}
							}
							this.dgPSAHG.SetCurrentCell(row, 1);
						}
						else
						{
							cmbBox.Text = string.Empty;
							this.dgPSAHG.SetCurrentCell(row, 1);
						}
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Checks if the user entered the valid lot number.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBox_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				if (this.cmbBox.SelectedIndex == -1 &&
					this.cmbBox.Text.Trim() != string.Empty)
					e.Cancel = true;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Copy the comment entered in combo box to the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxComment_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				int row = this.dgPSAHG.CurrentCell.RowNumber;
				int col = this.dgPSAHG.CurrentCell.ColumnNumber;

				if (col == 6)
				{
					this._dtDAT.Rows[row][ARTIFICIAL.AHGComment] = this.cmbBoxComment.Text;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Clears the datagrid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			ClearGrid();
			this.OnUserActivity();
		}

		/// <summary>
		/// Clears the grid. This method is public because it is being invoked by context menu from main form of the UC_56
		/// </summary>
		public void ClearGrid()
		{
			if (this.IsGridEmpty() == true)
				return;

			if (this.IsGridPartiallyCompleted() == true)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for this task?", "PT");

                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);

				if (dlg.DialogResult == DialogResult.OK)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionPatientTestInactivated(this._orderedTest, this._testingTech);
				
					if (this._orderedTest.OrderableTestId != (int)Common.OrderableTest.TAS &&
						this._orderedTest.OrderableTestId != (int)Common.OrderableTest.ABS)
					{
						this._orderedTest.InactivateTestResults(exRep, Common.UpdateFunction.DataGridDatClearGrid);
					}
					else
					{
						this._orderedTest.InactivateTestResultsForOrderableTest(exRep, (int)Common.OrderableTest.DAT, Common.UpdateFunction.DataGridDatClearGrid);
					}
					this.ClearTestResults(true);
					this.AddRemoveQCRowsToDataGrid(false);
				}
				else
					return;
			}
			else
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
				{
					this.ClearTestResults(false);
					this.AddRemoveQCRowsToDataGrid(false);
				}
				else
					return;
			}
			this._dtDAT.Rows[0][ARTIFICIAL.OrderedTestRowVersion] = this._orderedTest.RowVersion;

			if (this._orderedTest.OrderableTestId == (int)Common.OrderableTest.TAS ||
				this._orderedTest.OrderableTestId == (int)Common.OrderableTest.ABS)
			{
				OnRowVersionChanged(this._orderedTest.RowVersion);
			}
		}

		/// <summary>
		/// Check if grid is empty (contains no test results)
		/// </summary>
		/// <returns></returns>
		public bool IsGridEmpty()
		{
			DataTable dt = ((DataView)this.dgPSAHG.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._testStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
			{
				foreach(DataRow dr in this._dtDAT.Rows)
				{
					if (dr[TABLE.Reagent.LotNumber].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.AHG].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.CC].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.AHGInterp].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.AHGComment].ToString().Trim() != string.Empty)
						return false;
				}
			}
			else
			{
				if (this._dtDAT.Rows[0][ARTIFICIAL.AHGInterp].ToString().Trim() != string.Empty)
					return false;
				else
					return true;
			}

			return true;
		}

		/// <summary>
		/// Check if there are any results from previous testing
		/// </summary>
		/// <returns></returns>
		private bool IsGridPartiallyCompleted()
		{
			foreach(DataRow dr in this._dtDAT.Rows)
			{
				if ((bool)dr[ARTIFICIAL.LotNumberSave] == false)
					return true;
				if ((bool)dr[ARTIFICIAL.AHGSave] == false)
					return true;
				if ((bool)dr[ARTIFICIAL.CCSave] == false)
					return true;
				if ((bool)dr[ARTIFICIAL.AHGInterpSave] == false)
					return true;
			}

			return false;
		}
		
		private void _dcTextKeyTrapCol_MouseClick(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			try
			{
				if (e.Button == MouseButtons.Right)
				{
					if (this._dtDAT.Rows.Count > 0)
					{
						this.ContextMenu.Show(this, new Point(e.X, e.Y));
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgPSAHG_Enter(object sender, System.EventArgs e)
		{
			try
			{
				this.dgPSAHG.SetCurrentCell(0, 2);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgPSAHG_Leave(object sender, System.EventArgs e)
		{
			try
			{
				for (int i=0 ; i<this._dtDAT.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgPSAHG_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						this.SelectNextControl(this.dgPSAHG,true,true,false,false);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Checks if the reagent entered in the row has expired
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForExpiredAntisera(System.Data.DataRow drLotNumber)
		{
			DateTime LotExpirationDate;
			DialogResult result = DialogResult.Yes;
			int row = this.dgPSAHG.CurrentCell.RowNumber;
			DateTime currentDate;

			currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if(drLotNumber.IsNull(TABLE.Reagent.LotExpirationDate) == false)
			{
				LotExpirationDate = System.Convert.ToDateTime(drLotNumber[TABLE.Reagent.LotExpirationDate]);
			}
			else
			{
				LotExpirationDate = DateTime.MaxValue;
			}

			if(LotExpirationDate >= currentDate)
			{
				if ( ((System.TimeSpan)(LotExpirationDate - currentDate)).Days < 1)
				{
					string sDlgMessage = "Antisera will expire at ";
					sDlgMessage += Common.VBECSDateTime.FormatDateTimeString(LotExpirationDate);
					sDlgMessage += ". ";
					sDlgMessage += "Continue to use?";
					result = MessageBox.Show(sDlgMessage, Common.StrRes.ValidMsg.UC041.AntiseraExpire().ResString, MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation);
				
					if (result != DialogResult.Yes)
					{
						return false;
					}
				}
				this._dtDAT.Rows[row][ARTIFICIAL.ReagentExpiredException] = DBNull.Value;
			}
			else
			{

				DlgExpiredAntisera dlg = new DlgExpiredAntisera(string.Empty, (Guid)drLotNumber[TABLE.Reagent.ReagentGuid], drLotNumber[TABLE.ReagentType.ReagentTypeName].ToString(), drLotNumber[TABLE.Reagent.LotNumber].ToString(), (DateTime)drLotNumber[TABLE.Reagent.LotExpirationDate]);

                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);

				if (dlg.DialogResult != DialogResult.Yes)
				{

					DataRow drRemovedLotNumber = this._dtRemovedLotNumbers.NewRow();

					drRemovedLotNumber[ARTIFICIAL.Lot_Number] = drLotNumber[TABLE.Reagent.LotNumber];
					drRemovedLotNumber[ARTIFICIAL.Manufacturer] = drLotNumber[TABLE.Reagent.ReagentManufacturerName];
						
					this._dtRemovedLotNumbers.Rows.Add(drRemovedLotNumber);

					return false;
				}
				else
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_reagent_QC, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionQC((Guid)drLotNumber[TABLE.Reagent.ReagentGuid], Guid.Empty, Guid.Empty, Guid.Empty, string.Empty, string.Empty, string.Empty, this.TestingTech);
					this._dtDAT.Rows[row][ARTIFICIAL.ReagentExpiredException] = exRep;
				}
			}

			return true;
		}

		/// <summary>
		/// Checks the inspection indicator on the reagent
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForSatisfactoryReagent(DataRow drLotNumber)
		{
			string sDlgMessage;

			if ((bool)drLotNumber[TABLE.Reagent.InspectionIndicator] == false)
			{
				sDlgMessage = "Reagent (";
				sDlgMessage += drLotNumber[ARTIFICIAL.Manufacturer].ToString();
				sDlgMessage += " ";
				sDlgMessage += drLotNumber[ARTIFICIAL.Lot_Number].ToString();
				sDlgMessage += " ";
				sDlgMessage += drLotNumber[ARTIFICIAL.ExpirationDate].ToString();
				sDlgMessage += ") was recorded as Unsatisfactory during shipment receipt. You are not allowed to use this reagent.";

				MessageBox.Show(sDlgMessage, Common.StrRes.ValidMsg.UC041.AntigenTypingWeakD().ResString, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				return false;
			}
			return true;
		}

		private void dgPSAHG_SizeChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this.dgPSAHG.TableStyles.Count>0)
				{
					DataGridTableStyle tblStyle = this.dgPSAHG.TableStyles[0];
					//
				    var dataGridColumnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.AHGComment];
				    if (dataGridColumnStyle != null)
				    {
				        var gridColumnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.Indicator];
				        if (gridColumnStyle != null)
				        {
				            var columnStyle = tblStyle.GridColumnStyles[ARTIFICIAL.TestType];
				            if (columnStyle != null)
				            {
				                var style = tblStyle.GridColumnStyles[TABLE.Reagent.LotNumber];
				                if (style != null)
				                {
				                    var dataGridColumnStyle1 = tblStyle.GridColumnStyles[ARTIFICIAL.AHG];
				                    if (dataGridColumnStyle1 != null)
				                    {
				                        var gridColumnStyle1 = tblStyle.GridColumnStyles[ARTIFICIAL.CC];
				                        if (gridColumnStyle1 != null)
				                        {
				                            var columnStyle1 = tblStyle.GridColumnStyles[ARTIFICIAL.AHGInterp];
				                            if (columnStyle1 != null)
				                                dataGridColumnStyle.Width = this.dgPSAHG.Width -
				                                                            (gridColumnStyle.Width +
				                                                             columnStyle.Width +
				                                                             style.Width +
				                                                             dataGridColumnStyle1.Width +
				                                                             gridColumnStyle1.Width +
				                                                             columnStyle1.Width + 7);
				                        }
				                    }
				                }
				            }
				        }
				    }
				    var style1 = tblStyle.GridColumnStyles[ARTIFICIAL.AHGComment];
                    //CR 3554
				    if (style1 != null)
				        this.cmbBoxComment.Width = style1.Width;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// Invoke row changed event
		/// </summary>
		/// <param name="rowVersion"></param>
		protected virtual void OnRowVersionChanged(byte[] rowVersion)
		{
			if (RowVersionChanged != null)
				RowVersionChanged(this, EventArgs.Empty, rowVersion);
		}
	}
}
